from app.db import database

COLLECTION_NAME = "account_settings"

def get_account_settings(db: database.MongoDB) -> dict:
    return db[COLLECTION_NAME].find_one({}) or {}

def update_account_settings(account_id: str, data: dict, db: database.MongoDB) -> dict:
    db[COLLECTION_NAME].update_one({"account_id": account_id}, {"$set": data}, upsert=True)
    return db[COLLECTION_NAME].find_one({"account_id": account_id})
